from COCO import *
import cvxpy as cp
import copy

class Solver():
    def __init__(self, problem):
        assert isinstance(problem, COCO)
        self.problem = problem
        self.x_dim = problem.x_dim
        self.constraint_dim = problem.constraint_dim
        self.loss = 0
        self.constraint_violation = 0
        self.loss_list = []
        self.constraint_violation_list = []

    # update cumulative loss and constraint violation
    def update_all(self,H,z,A,a,x):
        self.loss += np.linalg.norm(np.dot(H, x) - z) **2/ 2
        self.constraint_violation += max(0, np.dot(A[0], x).reshape((1,)) - a[0].reshape((1,))) + max(0, np.dot(A[0], x).reshape((1,)) - a[0].reshape((1,)))
        # print(self.constraint_violation)
        a = copy.deepcopy(self.constraint_violation)
        self.loss_list.append(self.loss)
        self.constraint_violation_list.append(a)

    def update_observe(self,H,z,A,a):
        self.H_estimate = H
        self.z_estimate = z
        self.A_estimate = A
        self.a_estimate = a

    @property
    def run_one_step(self):
        raise NotImplementedError

    # run an experiment with 5000 rounds
    def run(self):
        for t in range(5000):
           x = self.run_one_step
           Observe = self.problem.observe(t)
           self.update_observe(H = Observe[0],z = Observe[1],A = Observe[2],a = Observe[3])
           self.update_all(H = Observe[0],z = Observe[1],A = Observe[2],a = Observe[3],x = x)

class RECOO(Solver):
    def __init__(self,problem):
        super().__init__(problem)
        self.count = 1
        self.vq = np.zeros(self.constraint_dim)
        self.choice = []

    @property
    def run_one_step(self):
        if self.count == 1:
            self.count += 1
            self.choice.append(np.random.uniform(low = -5, high = 5, size = (10,1)))
            return self.choice[-1]
        else:
            self.alpha = np.sqrt(self.count)
            self.eta = np.sqrt(self.count) / 1
            self.gamma = math.pow(self.count, 1 / 2 + 0.01)
            for i in range(2):
                self.vq[i] = max(self.eta, self.vq[i] + self.gamma * max(0, np.dot( self.A_estimate[i], self.choice[-1]) - self.a_estimate[i]))
            gra = np.dot(self.H_estimate.T, np.matmul(self.H_estimate, self.choice[-1]) - self.z_estimate).T
            x = cp.Variable(shape=(self.x_dim, 1))
            constraints = [x >= -5, x <= 5]
            obj = cp.Minimize(
                gra @ x + self.gamma * (
                            self.vq[0] * (cp.abs(self.A_estimate[0] @ x - self.a_estimate[0]) + self.A_estimate[0] @ x - self.a_estimate[0]) / 2 + self.vq[
                        1] * (
                                    cp.abs(self.A_estimate[1] @ x - self.a_estimate[1]) + self.A_estimate[1] @ x - self.a_estimate[
                                1]) / 2) + self.alpha * cp.square(
                    cp.norm(x - self.choice[-1])))
            prob = cp.Problem(obj, constraints)
            prob.solve()
            self.choice.append(x.value)
            self.count += 1
            return x.value

def projection(x):
    for i in range(len(x)):
        if x[i] < -5:
            x[i] = -5
        if x[i] > 5:
            x[i] = 5
        else:
            x[i] = x[i]
    return x

class Alg_Yi(Solver):
    def __init__(self,problem):
        super().__init__(problem)
        self.count = 1
        self.choice = []
        self.vq = np.zeros(self.constraint_dim)

    @property
    def run_one_step(self):
        if self.count == 1:
            self.count += 1
            self.choice.append(np.random.uniform(low = -5, high = 5, size = (10,1)))
            self.x_i = self.choice[-1]
            return self.choice[-1]
        else:
            self.congra = []
            for i in range(2):
                if np.dot(self.A_estimate[i], self.choice[-1]) - self.a_estimate[i] > 0:
                    self.congra.append(self.A_estimate[i])
                else:
                    self.congra.append(np.zeros(10))
            self.alpha = 0.8 / np.sqrt(self.count )
            self.beta = 5 / np.sqrt(self.count)
            self.gamma = 0.5 / np.sqrt(self.count)
            for i in range(self.constraint_dim):
                self.vq[i] = max(0, (1 - self.beta * self.gamma) * self.vq[i] + self.gamma * (
                            max(0, np.dot(self.A_estimate[i], self.x_i) - self.a_estimate[i]) + np.dot(self.congra[i], self.choice[-1] - self.x_i)))
            self.congra = []
            for i in range(2):
                if np.dot(self.A_estimate[i], self.choice[-1]) - self.a_estimate[i] > 0:
                    self.congra.append(self.vq[i] * self.A_estimate[i])
                else:
                    self.congra.append(np.zeros(10))
            gra = np.dot(self.H_estimate.T, np.matmul(self.H_estimate, self.choice[-1]) - self.z_estimate).T + self.congra[0] + self.congra[1]
            x_1 = self.choice[-1] - self.alpha * gra.T
            x_2 = projection(x_1)
            self.choice.append(x_2)
            self.x_i = self.choice[-2]
            self.count += 1
            return self.choice[-1]







